/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.http;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.http.POTrackingServletRequestWrapper;
import filenet.ws.listener.http.POTrackingServletResponseWrapper;
import filenet.ws.listener.http.WSListenerServlet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class POTrackingFilter
implements Filter {
    private StringBuffer buf = new StringBuffer();
    private static final String newsep = "\n";
    private static final String sepLine = "------------------------------------------\n";
    private FilterConfig config = null;
    private ServletContext context = null;
    private String m_name = null;
    private String m_alertFile = null;
    private boolean enable = false;

    public void destroy() {
    }

    private void traceRequest(HttpServletRequest request) {
        this.buf.append(sepLine);
        this.buf.append(new Date()).append(" ").append(this.config.getFilterName()).append(" HTTPRequest: ").append(request.getRequestURI()).append(newsep);
        this.buf.append(newsep).append("Method: ").append(request.getMethod());
        this.buf.append(newsep).append("Request URI: ").append(request.getRequestURI());
        this.buf.append(newsep).append("Protocol: ").append(request.getProtocol());
        if (request.getPathInfo() != null) {
            this.buf.append(newsep).append("PathInfo: ").append(request.getPathInfo());
        }
        this.buf.append(newsep).append("ContextPath: ").append(request.getContextPath());
        this.buf.append(newsep).append("PathTranslated: ").append(request.getPathTranslated());
        this.buf.append(newsep).append("ServletPath: ").append(request.getServletPath());
        this.buf.append(newsep).append("QueryString: ").append(request.getQueryString());
        this.buf.append(newsep).append("Remote Address: ").append(request.getRemoteAddr());
        this.buf.append(newsep).append(newsep).append("=== Headers Information: ");
        Enumeration headerNamesEnum = request.getHeaderNames();
        if (headerNamesEnum != null) {
            while (headerNamesEnum.hasMoreElements()) {
                String headerName = (String)headerNamesEnum.nextElement();
                this.buf.append(newsep).append(headerName).append("=");
                Enumeration headerValuesEnum = request.getHeaders(headerName);
                if (headerValuesEnum == null) continue;
                boolean moreToCome = false;
                do {
                    this.buf.append(headerValuesEnum.nextElement());
                    moreToCome = headerValuesEnum.hasMoreElements();
                    if (!moreToCome) continue;
                    this.buf.append(",");
                } while (moreToCome);
            }
        }
        this.buf.append(newsep).append(newsep).append("=== Parameter Information: ");
        Enumeration paramNamesEnum = request.getParameterNames();
        if (paramNamesEnum != null) {
            while (paramNamesEnum.hasMoreElements()) {
                String paramName = (String)paramNamesEnum.nextElement();
                this.buf.append(newsep).append(paramName).append("=").append(Logger.asString(request.getParameterValues(paramName)));
            }
        }
        this.buf.append(newsep).append(newsep).append("=== Request Attribute Information: ");
        Enumeration attributeNames = request.getAttributeNames();
        if (attributeNames != null) {
            while (attributeNames.hasMoreElements()) {
                String attribName = (String)attributeNames.nextElement();
                this.buf.append(newsep).append(attribName).append("=").append(Logger.asString(request.getAttribute(attribName)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String m_method = "doFilter";
        boolean userEnable = WSListenerServlet.getPOTracking(this.enable);
        if (userEnable) {
            this.traceRequest((HttpServletRequest)request);
            POTrackingServletRequestWrapper requestWrapper = new POTrackingServletRequestWrapper((HttpServletRequest)request);
            POTrackingServletResponseWrapper responseWrapper = new POTrackingServletResponseWrapper((HttpServletResponse)response);
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            String outputText = responseWrapper.toString();
            if (responseWrapper.getStatus() == 500) {
                this.buf.append(newsep).append("=== Request ===").append(newsep).append(requestWrapper.toString());
                this.buf.append(newsep).append("=== Response Status: ").append(responseWrapper.getStatus()).append(newsep).append(outputText).append(newsep).append(sepLine);
                String logText = this.buf.toString();
                this.context.log(logText);
                FileWriter fWriter = null;
                if (this.m_alertFile != null) {
                    try {
                        fWriter = new FileWriter(this.m_alertFile, true);
                        fWriter.write(logText);
                    }
                    catch (Exception e) {
                        this.context.log(this.m_name + ": Failed to write to " + this.m_alertFile + ", ex=" + e.getMessage());
                    }
                    finally {
                        if (fWriter != null) {
                            try {
                                fWriter.close();
                            }
                            catch (Exception ex) {}
                        }
                    }
                }
            }
            if (responseWrapper.writerUsed) {
                PrintWriter writer = response.getWriter();
                writer.write(outputText);
                writer.close();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.context = filterConfig.getServletContext();
        this.m_name = this.config.getFilterName();
        String sEnable = filterConfig.getInitParameter("enable");
        this.enable = new Boolean(sEnable);
        File f = new File(this.context.getRealPath("/WEB-INF"), "POEXCEPTION.txt");
        this.m_alertFile = f.getAbsolutePath();
        this.context.log(this.m_name + " tracking " + (this.enable ? "enabled" : "NOT enabled") + ", alert file=" + this.m_alertFile);
    }
}

